/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.activitystreams;

/**
 * <code>ActivityStreamFilter</code> allows filtering activity streams.
 * @since 0.0.10
 */
public interface ActivityStreamFilter {

    /**
     * includes ALL streams
     */
    static final ActivityStreamFilter ALL = new ActivityStreamFilter() {
        public boolean includes(ActivityStream stream) {
            return true;
        }
    };

    /**
     * Checks if the given activity stream is to be included.
     * @param stream the activity stream to check
     * @return <code>true</code> to allow the activity stream
     */
    boolean includes(ActivityStream stream);
}