/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

/**
 * <code>AggregateOptions</code> provides options for activity aggregation.
 * @since 0.0.10
 */
public interface AggregateOptions {

    /**
     * Default aggregation options
     */
    static final AggregateOptions DEFAULT = new AggregateOptions() {

        public ActivityStreamFilter getActivityStreamFilter() {
            return ActivityStreamFilter.ALL;
        }

        public String[] relationshipTypes() {
            return null;
        }
    };

    /**
     * Aggregation options that only list the direct streams not following any relationships
     * @since 0.0.14
     */
    static final AggregateOptions DIRECT = new AggregateOptions() {

        public ActivityStreamFilter getActivityStreamFilter() {
            return ActivityStreamFilter.ALL;
        }

        public String[] relationshipTypes() {
            return new String[0];
        }
    };

    /**
     * Returns the activity stream filter
     * @return the activity stream filter
     */
    ActivityStreamFilter getActivityStreamFilter();


    /**
     * Returns the list of relationship types to follow while aggregating. A <code>null</code> return value specifies
     * to use the configured default, and empty array specifies not to follow any relationships.
     * @return the list of relationship types
     */
    String[] relationshipTypes();

}