/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

/**
 * <code>MutableActivity</code>...
 */
public interface MutableActivity extends Activity {

    MutableActivity setId(String id);

    MutableActivity setURL(String url);

    MutableActivity setVerb(String verb);

    MutableActivity setTitle(String title);

    MutableActivity setActor(ActivityObject actor);

    MutableActivity setActorUserId(String userId);

    MutableActivity setContent(String content);

    MutableActivity setTarget(ActivityObject target);

    MutableActivity setObject(ActivityObject object);

    MutableActivity setPublished(long published);

    MutableActivity setProvider(ActivityObject provider);

    MutableActivity setGenerator(ActivityObject provider);

    MutableActivity setUpdated(long updated);

    MutableActivity setIcon(MediaLink icon);

    /**
     * Sets the property with the give name and value.
     * @param name name of the property
     * @param value value of the property
     * @return this object for chaining.
     * @since 0.0.10
     */
    MutableActivity setProperty(String name, Object value);
}