/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

/**
 * <code>MutableActivityObject</code>...
 */
public interface MutableActivityObject extends ActivityObject {

    MutableActivityObject setId(String id);

    MutableActivityObject setURL(String url);

    MutableActivityObject setObjectType(String objectType);

    MutableActivityObject setAuthor(ActivityObject author);

    MutableActivityObject setAuthorUserId(String userId);

    MutableActivityObject setContent(String content);

    MutableActivityObject setDisplayName(String displayName);

    MutableActivityObject setSummary(String summary);

    MutableActivityObject setPublished(long published);

    MutableActivityObject setUpdated(long updated);

    MutableActivityObject setImage(MediaLink icon);

    MutableActivityObject setAttachments(ActivityObject[] attachments);

    MutableActivityObject setDownstreamDuplicates(String[] ids);

    MutableActivityObject setUpstreamDuplicates(String[] ids);

    /**
     * Sets the property with the give name and value.
     * @param name name of the property
     * @param value value of the property
     * @return this object for chaining.
     * @since 0.0.10
     */
    MutableActivityObject setProperty(String name, Object value);

}