/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

/**
 * Defines the well known object types as specified in
 * http://activitystrea.ms/specs/json/schema/activity-schema.html#object-types
 */
@SuppressWarnings("UnusedDeclaration")
public interface ObjectTypes {

    /**
     * Represents any kind of significant notification.
     */
    static String ALERT = "alert";
    /**
     * Represents any kind of software application.
     */
    static String APPLICATION = "application";
    /**
     * Represents objects such as news articles, knowledge base entries, or other similar construct. Such objects generally consist of paragraphs of text, in some cases incorporating embedded media such as photos and inline hyperlinks to other resources.
     */
    static String ARTICLE = "article";
    /**
     * Represents audio content of any kind. Objects of this type MAY contain an additional property as specified in Section 3.1.
     */
    static String AUDIO = "audio";
    /**
     * Represents a badge or award granted to an object (typically a person object)
     */
    static String BADGE = "badge";
    /**
     * Objects of this type are used to carry arbitrary Base64-encoded binary data within an Activity Stream object. It is primarily intended to attach binary data to other types of objects through the use of the attachments property. Objects of this type will contain the additional properties specified in Section 3.2.
     */
    static String BINARY = "binary";
    /**
     * Represents a pointer to some URL -- typically a web page. In most cases, bookmarks are specific to a given user and contain metadata chosen by that user. Bookmark Objects are similar in principle to the concept of bookmarks or favorites in a web browser. A bookmark represents a pointer to the URL, not the URL or the associated resource itself. Objects of this type SHOULD contain an additional targetUrl property whose value is a String containing the IRI of the target of the bookmark.
     */
    static String BOOKMARK = "bookmark";
    /**
     * Represents a generic collection of objects of any type. This object type can be used, for instance, to represent a collection of files like a folder; a collection of photos like an album; and so forth. Objects of this type MAY contain an additional objectTypes property whose value is an Array of Strings specifying the expected objectType of objects contained within the collection.
     */
    static String COLLECTION = "collection";
    /**
     * Represents a textual response to another object. Objects of this type MAY contain an additional inReplyTo property whose value is an Array of one or more other Activity Stream Objects for which the object is to be considered a response.
     */
    static String COMMENT = "comment";
    /**
     * Represents a device of any sort.
     */
    static String DEVICE = "device";
    /**
     * Represents an event that occurs at a certain location during a particular period of time. Objects of this type MAY contain the additional properties specified in Section 3.3.
     */
    static String EVENT = "event";
    /**
     * Represents any form of document or file. Objects of this type MAY contain an additional fileUrl property whose value a dereferenceable IRI that can be used to retrieve the file; and an additional mimeType property whose value is the MIME type of the file described by the object.
     */
    static String FILE = "file";
    /**
     * Represents a game or competition of any kind.
     */
    static String GAME = "game";
    /**
     * Represents a grouping of objects in which member objects can join or leave.
     */
    static String GROUP = "group";
    /**
     * Represents a graphical image. Objects of this type MAY contain an additional fullImage property whose value is an Activity Streams Media Link to a "full-sized" representation of the image.
     */
    static String IMAGE = "image";
    /**
     * Represents a report about a problem or situation that needs to be resolved. For instance, the issue object can be used to represent reports detailing software defects, or reports of acceptable use violations, and so forth. Objects of this type MAY contain the additional properties specified in Section 3.4.
     */
    static String ISSUE = "issue";
    /**
     * Represents information about a job or a job posting.
     */
    static String JOB = "job";
    /**
     * Represents a short-form text message. This object is intended primarily for use in "micro-blogging" scenarios and in systems where users are invited to publish short, often plain-text messages whose useful lifespan is generally shorter than that of an article of weblog entry. A note is similar in structure to an article, but typically does not have a title or distinct paragraphs and tends to be much shorter in length.
     */
    static String NOTE = "note";
    /**
     * Represents an offer of any kind.
     */
    static String OFFER = "offer";
    /**
     * Represents an organization of any kind.
     */
    static String ORGANIZATION = "organization";
    /**
     * Represents an area, typically a web page, that is representative of, and generally managed by a particular entity. Such areas are usually dedicated to displaying descriptive information about the entity and showcasing recent content such as articles, photographs and videos. Most social networking applications, for example, provide individual users with their own dedicated "profile" pages. Several allow similar types of pages to be created for commercial entities, organizations or events. While the specific details of how pages are implemented, their characteristics and use may vary, the one unifying property is that they are typically "owned" by a single entity that is represented by the content provided by the page itself.
     */
    static String PAGE = "page";
    /**
     * Represents an individual person.
     */
    static String PERSON = "person";
    /**
     * Represents a physical location. Locations can be represented using geographic coordinates, a physical address, a free-form location name, or any combination of these. Objects of this type MAY contain the additional properties specified in Section 3.5.
     */
    static String PLACE = "place";
    /**
     * Represents any form of process. For instance, a long-running task that is started and expected to continue operating for a period of time.
     */
    static String PROCESS = "process";
    /**
     * Represents a commercial good or service. Objects of this type MAY contain an additional fullImage property whose value is an Activity Streams Media Link to an image resource representative of the product.
     */
    static String PRODUCT = "product";
    /**
     * Represents a question or a poll. Objects of this type MAY contain an additional options property whose value is an Array of possible answers to the question in the form of Activity Stream objects of any type.
     */
    static String QUESTION = "question";
    /**
     * Represents a primarily prose-based commentary on another object. Objects of this type MAY contain a rating property as specified in Section 4.4.
     */
    static String REVIEW = "review";
    /**
     * Represents any form of hosted or consumable service that performs some kind of work or benefit for other entities. Examples of such objects include websites, businesses, etc.
     */
    static String SERVICE = "service";
    /**
     * Represents an activity that has yet to be completed. Objects of this type SHOULD contain additional properties as specified in Section 3.6.
     */
    static String TASK = "task";
    /**
     * Represents video content of any kind. Objects of this type MAY contain additional properties as specified in Section 3.1.
     */
    static String VIDEO = "video";
}