/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

/**
 * Defines the well known verbs as specified in
 * http://activitystrea.ms/specs/json/schema/activity-schema.html#verbs
 */
@SuppressWarnings("UnusedDeclaration")
public interface Verbs {

    /**
     * Indicates that that the actor has accepted the object. For instance, a person accepting an award, or accepting an assignment.
     */
    static String ACCEPT = "accept";
    /**
     * * Indicates that the actor has accessed the object. For instance, a person accessing a room, or accessing a file.
     */
    static String ACCESS = "access";
    /**
     * Indicates that the actor has acknowledged the object. This effectively signals that the actor is aware of the object's existence.
     */
    static String ACKNOWLEDGE = "acknowledge";
    /**
     * Indicates that the actor has added the object to the target. For instance, adding a photo to an album.
     */
    static String ADD = "add";
    /**
     * Indicates that the actor agrees with the object. For example, a person agreeing with an argument, or expressing agreement with a particular issue.
     */
    static String AGREE = "agree";
    /**
     * Indicates that the actor has appended the object to the target. For instance, a person appending a new record to a database.
     */
    static String APPEND = "append";
    /**
     * Indicates that the actor has approved the object. For instance, a manager might approve a travel request.
     */
    static String APPROVE = "approve";
    /**
     * Indicates that the actor has archived the object.
     */
    static String ARCHIVE = "archive";
    /**
     * Indicates that the actor has assigned the object to the target.
     */
    static String ASSIGN = "assign";
    /**
     * Indicates that the actor is currently located at the object. For instance, a person being at a specific physical location.
     */
    static String AT = "at";
    /**
     * Indicates that the actor has attached the object to the target. For instance, a person attaching a file to a wiki page or an email.
     */
    static String ATTACH = "attach";
    /**
     * Indicates that the actor has attended the object. For instance, a person attending a meeting.
     */
    static String ATTEND = "attend";
    /**
     * Indicates that the actor has authored the object. Note that this is a more specific form of the verb "create".
     */
    static String AUTHOR = "author";
    /**
     * Indicates that the actor has authorized the object. If a target is specified, it means that the authorization is specifically in regards to the target. For instance, a service can authorize a person to access a given application; in which case the actor is the service, the object is the person, and the target is the application. In contrast, a person can authorize a request; in which case the actor is the person and the object is the request and there might be no explicit target.
     */
    static String AUTHORIZE = "authorize";
    /**
     * Indicates that the actor has borrowed the object. If a target is specified, it identifies the entity from which the object was borrowed. For instance, if a person borrows a book from a library, the person is the actor, the book is the object and the library is the target.
     */
    static String BORROW = "borrow";
    /**
     * Indicates that the actor has built the object. For example, if a person builds a model or compiles code.
     */
    static String BUILD = "build";
    /**
     * Indicates that the actor has canceled the object. For instance, canceling a calendar event.
     */
    static String CANCEL = "cancel";
    /**
     * Indicates that the actor has closed the object. For instance, the object could represent a ticket being tracked in an issue management system.
     */
    static String CLOSE = "close";
    /**
     * Indicates that the actor has completed the object.
     */
    static String COMPLETE = "complete";
    /**
     * Indicates that the actor has confirmed or agrees with the object. For instance, a software developer might confirm an issue reported against a product.
     */
    static String CONFIRM = "confirm";
    /**
     * Indicates that the actor has consumed the object. The specific meaning is dependent largely on the object's type. For instance, an actor may "consume" an audio object, indicating that the actor has listened to it; or an actor may "consume" a book, indicating that the book has been read. As such, the "consume" verb is a more generic form of other more specific verbs such as "read" and "play".
     */
    static String CONSUME = "consume";
    /**
     * Indicates that the actor has checked-in to the object. For instance, a person checking-in to a Place.
     */
    static String CHECKIN = "checkin";
    /**
     * Indicates that the actor has created the object.
     */
    static String CREATE = "create";
    /**
     * Indicates that the actor has deleted the object. This implies, but does not require, the permanent destruction of the object.
     */
    static String DELETE = "delete";
    /**
     * Indicates that the actor has delivered the object. For example, delivering a package.
     */
    static String DELIVER = "deliver";
    /**
     * Indicates that the actor has denied the object. For example, a manager may deny a travel request.
     */
    static String DENY = "deny";
    /**
     * Indicates that the actor disagrees with the object.
     */
    static String DISAGREE = "disagree";
    /**
     * Indicates that the actor dislikes the object. Note that the "dislike" verb is distinct from the "unlike" verb which assumes that the object had been previously "liked".
     */
    static String DISLIKE = "dislike";
    /**
     * Indicates that the actor has experienced the object in some manner. Note that, depending on the specific object types used for both the actor and object, the meaning of this verb can overlap that of the "consume" and "play" verbs. For instance, a person might "experience" a movie; or "play" the movie; or "consume" the movie. The "experience" verb SHOULD be considered a more generic form of other more specific verbs as "consume", "play", "watch", "listen", and "read"
     */
    static String EXPERIENCE = "experience";
    /**
     * Indicates that the actor marked the object as an item of special interest.
     */
    static String FAVORITE = "favorite";
    /**
     * Indicates that the actor has found the object. If a target is specified, it SHOULD indicate where the object was found.
     */
    static String FIND = "find";
    /**
     * Indicates that the actor has flagged the object as being inappropriate for some reason. When using this verb, the context property, as specified within Section 4.1 can be used to provide additional detail about why the object has been flagged.
     */
    static String FLAG_AS_INAPPROPRIATE = "flag-as-inappropriate";
    /**
     * Indicates that the actor began following the activity of the object. In most cases, the objectType will be a "person", but it can potentially be of any type that can sensibly generate activity. Processors MAY ignore (silently drop) successive identical "follow" activities.
     */
    static String FOLLOW = "follow";
    /**
     * Indicates that the actor is giving an object to the target. Examples include one person giving a badge object to another person. The object identifies the object being given. The target identifies the receiver.
     */
    static String GIVE = "give";
    /**
     * Indicates that the actor is hosting the object. As in hosting an event, or hosting a service.
     */
    static String HOST = "host";
    /**
     * Indicates that the actor has ignored the object. For instance, this verb may be used when an actor has ignored a friend request, in which case the object may be the request-friend activity.
     */
    static String IGNORE = "ignore";
    /**
     * Indicates that the actor has inserted the object into the target.
     */
    static String INSERT = "insert";
    /**
     * Indicates that the actor has installed the object, as in installing an application.
     */
    static String INSTALL = "install";
    /**
     * Indicates that the actor has interacted with the object. For instance, when one person interacts with another.
     */
    static String INTERACT = "interact";
    /**
     * Indicates that the actor has invited the object, typically a person object, to join or participate in the object described by the target. The target could, for instance, be an event, group or a service.
     */
    static String INVITE = "invite";
    /**
     * Indicates that the actor has become a member of the object. This specification only defines the meaning of this verb when the object of the Activity has an objectType of group, though implementors SHOULD be prepared to handle other types of objects.
     */
    static String JOIN = "join";
    /**
     * Indicates that the actor has left the object. For instance, a Person leaving a Group or checking-out of a Place.
     */
    static String LEAVE = "leave";
    /**
     * Indicates that the actor marked the object as an item of special interest. The "like" verb is considered to be an alias of "favorite". The two verb are semantically identical.
     */
    static String LIKE = "like";
    /**
     * Indicates that the actor has listened to the object. This is typically only applicable for objects representing audio content, such as music, and audio-book, or a radio broadcast. The "listen" verb is a more specific form of the "consume", "experience" and "play" verbs.
     */
    static String LISTEN = "listen";
    /**
     * Indicates that the actor has lost the object. For instance, if a person loses a game.
     */
    static String LOSE = "lose";
    /**
     * Indicates the creation of a friendship that is reciprocated by the object. Since this verb implies an activity on the part of its object, processors MUST NOT accept activities with this verb unless they are able to verify through some external means that there is in fact a reciprocated connection. For example, a processor may have received a guarantee from a particular publisher that the publisher will only use this Verb in cases where a reciprocal relationship exists.
     */
    static String MAKE_FRIEND = "make-friend";
    /**
     * Indicates that the actor has opened the object. For instance, the object could represent a ticket being tracked in an issue management system.
     */
    static String OPEN = "open";
    /**
     * Indicates that the actor spent some time enjoying the object. For example, if the object is a video this indicates that the subject watched all or part of the video. The "play" verb is a more specific form of the "consume" verb.
     */
    static String PLAY = "play";
    /**
     * The "post" verb describes the act of authoring an object and then publishing it online. The actor can be any entity; the object can be of any object type; and the target, if specified, can be of any object type. A target, however, is not required.
     */
    static String POST = "post";
    /**
     * Indicates that the actor has presented the object. For instance, when a person gives a presentation at a conference.
     */
    static String PRESENT = "present";
    /**
     * Indicates that the actor has purchased the object. If a target is specified, in indicates the entity from which the object was purchased.
     */
    static String PURCHASE = "purchase";
    /**
     * Indicates that the actor has qualified for the object. If a target is specified, it indicates the context within which the qualification applies.
     */
    static String QUALIFY = "qualify";
    /**
     * Indicates that the actor read the object. This is typically only applicable for objects representing printed or written content, such as a book, a message or a comment. The "read" verb is a more specific form of the "consume", "experience" and "play" verbs.
     */
    static String READ = "read";
    /**
     * Indicates that the actor is receiving an object. Examples include a person receiving a badge object. The object identifies the object being received.
     */
    static String RECEIVE = "receive";
    /**
     * Indicates that the actor has rejected the object.
     */
    static String REJECT = "reject";
    /**
     * Indicates that the actor has removed the object from the target.
     */
    static String REMOVE_FRIEND = "remove-friend";
    /**
     * Indicates that the actor has removed the object from the collection of friends.
     */
    static String REMOVE = "remove";
    /**
     * Indicates that the actor has replaced the target with the object.
     */
    static String REPLACE = "replace";
    /**
     * Indicates that the actor has requested the object. If a target is specified, it indicates the entity from which the object is being requested.
     */
    static String REQUEST = "request";
    /**
     * Indicates the creation of a friendship that has not yet been reciprocated by the object.
     */
    static String REQUEST_FRIEND = "request-friend";
    /**
     * Indicates that the actor has resolved the object. For instance, the object could represent a ticket being tracked in an issue management system.
     */
    static String RESOLVE = "resolve";
    /**
     * Indicates that the actor has returned the object. If a target is specified, it indicates the entity to which the object was returned.
     */
    static String RETURN = "return";
    /**
     * Indicates that the actor has retracted the object. For instance, if an actor wishes to retract a previously published activity, the object would be the previously published activity that is being retracted.
     */
    static String RETRACT_MAYBE = "retract";
    /**
     * The "possible RSVP" verb indicates that the actor has made a possible RSVP for the object. This specification only defines the meaning of this verb when its object is an event (see Section 3.3), though implementors SHOULD be prepared to handle other object types as meaning MAY be provided by extension specifications. The use of this verb is only appropriate when the RSVP was created by an explicit action by the actor. It is not appropriate to use this verb when a user has been added as an attendee by an event organiser or administrator.
     */
    static String RSVP_MAYBE = "rsvp-maybe";
    /**
     * The "negative RSVP" verb indicates that the actor has made a negative RSVP for the object. This specification only defines the meaning of this verb when its object is an event (see Section 3.3), though implementors SHOULD be prepared to handle other object types as meaning MAY be provided by extension specifications. The use of this verb is only appropriate when the RSVP was created by an explicit action by the actor. It is not appropriate to use this verb when a user has been added as an attendee by an event organiser or administrator.
     */
    static String RSVP_NO = "rsvp-no";
    /**
     * The "positive RSVP" verb indicates that the actor has made a positive RSVP for an object. This specification only defines the meaning of this verb when its object is an event (see Section 3.3), though implementors SHOULD be prepared to handle other object types as meaning MAY be provided by extension specifications. The use of this verb is only appropriate when the RSVP was created by an explicit action by the actor. It is not appropriate to use this verb when a user has been added as an attendee by an event organiser or administrator.
     */
    static String RSVP_YES = "rsvp-yes";
    /**
     * Indicates that the actor has satisfied the object. If a target is specified, it indicate the context within which the object was satisfied. For instance, if a person satisfies the requirements for a particular challenge, the person is the actor; the requirement is the object; and the challenge is the target.
     */
    static String SATISFY = "satisfy";
    /**
     * Indicates that the actor has called out the object as being of interest primarily to him- or herself. Though this action MAY be shared publicly, the implication is that the object has been saved primarily for the actor's own benefit rather than to show it to others as would be indicated by the "share" verb.
     */
    static String SAVE = "save";
    /**
     * Indicates that the actor has scheduled the object. For instance, scheduling a meeting.
     */
    static String SCHEDULE = "schedule";
    /**
     * Indicates that the actor is or has searched for the object. If a target is specified, it indicates the context within which the search is or has been conducted.
     */
    static String SEARCH = "search";
    /**
     * Indicates that the actor has sold the object. If a target is specified, it indicates the entity to which the object was sold.
     */
    static String SELL = "sell";
    /**
     * Indicates that the actor has sent the object. If a target is specified, it indicates the entity to which the object was sent.
     */
    static String SEND = "send";
    /**
     * Indicates that the actor has called out the object to readers. In most cases, the actor did not create the object being shared, but is instead drawing attention to it.
     */
    static String SHARE = "share";
    /**
     * Indicates that the actor has sponsored the object. If a target is specified, it indicates the context within which the sponsorship is offered. For instance, a company can sponsor an event; or an individual can sponsor a project; etc.
     */
    static String SPONSOR = "sponsor";
    /**
     * Indicates that the actor has started the object. For instance, when a person starts a project.
     */
    static String START = "start";
    /**
     * Indicates that the actor has stopped following the object.
     */
    static String STOP_FOLLOWING = "stop-following";
    /**
     * Indicates that the actor has submitted the object. If a target is specified, it indicates the entity to which the object was submitted.
     */
    static String SUBMIT = "submit";
    /**
     * Indicates that the actor has associated the object with the target. For example, if the actor specifies that a particular user appears in a photo. the object is the user and the target is the photo.
     */
    static String TAG = "tag";
    /**
     * Indicates that the actor has terminated the object.
     */
    static String TERMINATE = "terminate";
    /**
     * Indicates that the actor has neither won or lost the object. This verb is generally only applicable when the object represents some form of competition, such as a game.
     */
    static String TIE = "tie";
    /**
     * Indicates that the actor has removed the object from the collection of favorited items.
     */
    static String UNFAVORITE = "unfavorite";
    /**
     * Indicates that the actor has removed the object from the collection of liked items.
     */
    static String UNLIKE = "unlike";
    /**
     * Indicates that the actor has not satisfied the object. If a target is specified, it indicates the context within which the object was not satisfied. For instance, if a person fails to satisfy the requirements of some particular challenge, the person is the actor; the requirement is the object and the challenge is the target.
     */
    static String UNSATISFY = "unsatisfy";
    /**
     * Indicates that the actor has removed the object from the collection of saved items.
     */
    static String UNSAVE = "unsave";
    /**
     * Indicates that the actor is no longer sharing the object. If a target is specified, it indicates the entity with whom the object is no longer being shared.
     */
    static String UNSHARE = "unshare";
    /**
     * The "update" verb indicates that the actor has modified the object. Use of the "update" verb is generally reserved to indicate modifications to existing objects or data such as changing an existing user's profile information.
     */
    static String UPDATE = "update";
    /**
     * Indicates that the actor has used the object in some manner.
     */
    static String USE = "use";
    /**
     * Indicates that the actor has watched the object. This verb is typically applicable only when the object represents dynamic, visible content such as a movie, a television show or a public performance. This verb is a more specific form of the verbs "experience", "play" and "consume".
     */
    static String WATCH = "watch";
    /**
     * Indicates that the actor has won the object. This verb is typically applicable only when the object represents some form of competition, such as a game.
     */
    static String WIN = "win";
}