/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.asset.api;

import java.util.Iterator;

/**
 * <code>AssetVersionManager</code> provides methods to manage {@link AssetVersion}s.
 * <p>
 * AssetVersionManager is created by adapting {@link org.apache.sling.api.resource.ResourceResolver}
 * to <code>AssetVersionManager</code>
 * <pre>
 *     AssetVersionManager versionManager = resolver.adaptTo(AssetVersionManager.class);
 * </pre>
 * */
public interface AssetVersionManager {

    /**
     * Creates a new version of an <code>Asset<code>.
     *
     * @param assetPath   Absolute path of the asset to version
     * @param label   Version label to be added to the newly created version
     *
     * @return The newly created AssetVersion
     *
     * @throws AssetException if version cannot be created.
     */
    AssetVersion createVersion(String assetPath, String label);

    /**
     * Restores an <code>Asset<code>.
     *
     * @param versionId version ID to be restored
     *
     * @return the restored {@link Asset}
     *
     * @throws AssetException if version with the given ID cannot be restored
     */
    Asset restore(String versionId);

    /**
     * Returns an {@link AssetVersion} corresponding to the given versionId.
     *  
     * @param versionId version ID to be looked up
     * @return the AssetVersion matching the given versionId
     */
    AssetVersion getVersion(String versionId);

    /**
     * Lists all available versions at the given path.
     *
     * @param assetPath Absolute path of the Asset
     *
     * @return all {@link AssetVersion}s of the given path or an empty iterator if no version has been created yet
     *
     * @throws AssetException if versions cannot be retrieved for the given Asset path
     */
    Iterator<? extends AssetVersion> listVersions(String assetPath);

}
