/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.asset.api;

import org.apache.sling.api.resource.Resource;
import java.io.InputStream;

/**
 * <code>Rendition</code> is a read only representation of a particular rendition of an {@link Asset}.
 * <p>
 * Rendition is an extension of a Sling Resource, therefore its adaptable.
 * <p>
 * Rendition is created by {@link Asset#setRendition(String, java.io.InputStream, java.util.Map)} and can be
 * retrieved either via {@link Asset#getRendition(String)} or by adapting a rendition {@link Resource}
 * to a <code>Rendition</code> type.
 * <pre>
 *     eg:
 *     // to create a rendition
 *     AssetManager assetManager = resolver.adaptTo(AssetManager.class);
 *     Asset asset = assetManager.getAsset("/path/to/asset/document.pdf");
 *     asset.setRendition("thumbnail.jpg", java.io.InputStream, java.util.Map);
 *
 *     // to get rendition
 *     Rendition rendition = asset.getRendition("thumbnail.jpg");
 *
 *     // to get rendition by adapting
 *     Rendition rendition = resource.adaptTo(Rendition.class);
 * </pre>
 * */
public interface Rendition extends Resource {

    /**
     * Returns the mime type of the rendition's binary.
     */
    String getMimeType();

    /**
     * Returns the size in bytes of the rendition's binary.
     *
     * @return The size.
     */
    long getSize();

    /**
     * Returns the <code>InputStream</code> representing the binary of this rendition.
     *
     * @return The input stream of the rendition's binary, or <code>null</code> if the binary is not found.
     *
     * @throws AssetIOException if stream cannot be read
     */
    InputStream getStream();
}
