/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import java.io.IOException;
import java.util.Map;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.crypto.CryptoException;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Interface for an OAuth 2.0 access token provider using Authorization Grants as defined in the Assertion Framework
 * for OAuth 2.0 Client Authentication and Authorization Grants
 * (see <a href="https://tools.ietf.org/html/rfc7523">RFC 7523</a>).
 *
 * @see AccessTokenRequestCustomizer
 *
 * @since 3.1
 */
@ProviderType
public interface AccessTokenProvider {

    /**
     * <p>Return a valid access token or throws an exception. A new access token is obtained from the authorization server
     * if needed, by generating a JWT and using it as authorization grant. Custom claims may be added via the
     * {@code claim} parameter. The custom claims do override the claims computed by a {@code AccessTokenProvider}
     * implementation.</p>
     *
     * <p>An implementation may or may not reuse the access tokens.</p>
     *
     * @param resolver The resource resolver to access the user associated to the {@code userId}
     * @param userId The user identifier which has access to the required asymmetric cryptographic material
     * @param claims An optional map of JWT claims that overrides the claims computed by a {@code AccessTokenProvider}
     *               implementation. Providing an empty map or {@code null} uses the default
     *               {@code AccessTokenProvider} implementation claims
     * @return A valid JWT access token or throws an Exception (does not return {@code null})
     * @throws CryptoException If an error occurred while generating/signing the JWT claim
     * @throws IOException If an error occurred while communicating with the authorization server
     * @throws NullPointerException If the {@code resolver} or the {@code userId} is {@code null}
     */
    String getAccessToken(ResourceResolver resolver, String userId, Map<String, ?> claims)
            throws CryptoException, IOException, NullPointerException;

}
