/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.auth.oauth;

import aQute.bnd.annotation.ConsumerType;

import java.util.List;
import java.util.Map;

/**
 * An interface to customize the token exchange/trade mechanism for JWT Bearer based request
 * for requesting an OAuth 2.0 access token. Implementers of this interface should use this to
 * customize the parameters to be sent in the request for exchanging the JWT for access token if
 * the api they use specifies non-standard parameters as opposed to the ones specified in
 * <a href="https://tools.ietf.org/html/rfc7523">RFC 7523</a>.
 *
 * @see AccessTokenProvider
 *
 * @since 3.6
 *
 */
@ConsumerType
public interface AccessTokenRequestCustomizer {

    /**
     * Specifies the property name of this customizer type
     */
    static final String CUSTOMIZER_TYPE_PROPERTY = "customizer.type";

    /**
     * Customizes the request parameters for trading JWT for an access token
     * @param requestContext The request context contains values or {@code null} for context keys
     *                       referenced in {@link AccessTokenProviderConstants}
     * @return The customized parameters for requesting access token in exchange for a JWT or {@code null}
     *         in which case no additional parameters are set on the request.
     *
     * @see AccessTokenProviderConstants
     */
    Map<String,String> getRequestParameters(Map<String, Object> requestContext);

    /**
     * Customizes the request headers for trading JWT for an access token
     * @param requestContext The request context contains values or {@code null} for context keys
     *                       referenced in {@link AccessTokenProviderConstants}

     * @return The customized headers for requesting access token in exchange for a JWT or {@code null}
     *         in which case no additional headers are set on the request.
     *
     * @see AccessTokenProviderConstants
     */
    Map<String, List<String>> getRequestHeaders(Map<String, Object> requestContext);
}
