/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import javax.servlet.http.HttpServletRequest;

import org.scribe.model.OAuthConfig;

/**
 * Interface that {@link Provider}s can implement to indicate
 * they can accept authorization code requests directly.
 */
public interface AuthorizationCodeAcceptor {

    /**
     * Return true if the request contains a valid authorization token
     * that should be used to request an access token from the identity provider.
     * The first provider to respond with true will handle the request.
     *
     * @param request The request object containing the information for the authentication.
     * @return true if accepted, false if not
     */
    boolean acceptsCodeRequest(HttpServletRequest request, OAuthConfig config);

}
