/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * This interface is intended to be implemented by an application which wants, upon authentication, to redirect the user
 * to an uri instead of login in to the local instance. A HandlerRedirect instance is bind to all specific
 * {@link org.apache.sling.auth.core.spi.AuthenticationHandler}s supporting the redirect handler.
 */
// AdobePatentID="3406US01"
public interface HandlerRedirect {

    /**
     * Return an URI to be redirected to instead of login in to the instance
     * @param request the request containing the information for the authentication
     * @param userId provider's userId
     * @param props map of all provider's properties for this userId
     * @return the redirect URI or <code>null</code> if the redirection must not happen.
     */
    public String getRedirectUri(HttpServletRequest request, String userId, Map<String, Object> props);

}
