/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@ProviderType
public interface OAuthManager {

    /**
     * Use a shared token stored on encryptedTokenNode to retrieve protected data with the specified {@link OAuthRequest}
     * @param encryptedTokenResource
     * @param configId
     * @param oauthRequest
     * @return
     * @throws IOException
     */
    public Response getOAuthDataWithSharedToken(Resource encryptedTokenResource, String configId, OAuthRequest oauthRequest) throws IOException;

    /**
     * Convenience method; same as:
     * <pre>
     * {@code
     * OAuthRequest oauthRequest = new OAuthRequest(url, Verb.GET);
     * getOAuthDataWithSharedToken(encryptedTokenResource, configId, oauthRequest);
     * }
     * </pre>
     * @param encryptedTokenResource
     * @param configId
     * @param url
     * @return
     * @throws IOException
     */
    public String getOAuthDataWithSharedToken(Resource encryptedTokenResource, String configId, String url) throws IOException;

    /**
     * Use the user's access token (stored on the cookie or user profile jcr node) to retrieve protected data with
     * the specified {@link OAuthRequest}
     * @param request
     * @param configId
     * @param oauthRequest
     * @return String text of response
     * @throws IOException
     */
    public Response getOAuthDataWithUserToken(SlingHttpServletRequest request, String configId, OAuthRequest oauthRequest) throws IOException;

    /**
     * Convenience method; same as:
     * <pre>
     * {@code
     * OAuthRequest oauthRequest = new OAuthRequest(url, Verb.GET);
     * getOAuthDataStreamWithUserToken(request, configId, oauthRequest);
     * }
     * </pre>
     * @param request
     * @param configId
     * @param url
     * @return
     * @throws IOException
     */
    public String getOAuthDataWithUserToken(SlingHttpServletRequest request, String configId, String url) throws IOException;

    /**
     * Retrieve the Provider implementation specific within the config with this configId
     * @param configId
     * @return the Provider or null if the config providerId doesn't match any registered providers
     */
    public Provider getProvider(String configId);

    /**
     * Retrieve the user id who has been authorized for the app configured; (The user id is stored in the
     * encrypted cookie)
     * @param request
     * @param configId the id of the configuration
     * @return
     */
    public String getAuthorizedId(HttpServletRequest request, String configId);
}
