/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import java.util.Map;

import aQute.bnd.annotation.ConsumerType;

/**
 * <p>This interface is intended to be implemented by an application which wants
 * to customize the validation of the users based on their profile.</p>
 *
 * <p>A {@code ProfileValidator} is bind to all {@link Provider} providers implementations
 * supporting the {@code ProfileValidator} and for which Provider#getId equals ProfileValidator#getId.</p>
 *
 * <p>Each {@link Provider} can be bind to either 0 or many {@code ProfileValidator} profile validators.
 * The profile validators are linked with a AND operator (a profile is valid if ALL profile validators
 * return {@code true})</p>
 */
@ConsumerType
public interface ProfileValidator {

    /**
     * Provider identifier used to map this profile validator to it.
     *
     * @return the provider identifier to map this profile validator to it.
     * @since 3.3
     */
    String getId();

    /**
     * Check the validity of a user profile.
     *
     * @param userId the non {@code null} user identifier.
     * @param profileData the non {@code null} profile data to check.
     * @return {@code true} if the profile is valid ; {@code false} otherwise.
     *
     * @since 3.3
     */
    boolean isValidProfile(String userId, Map<String, Object> profileData);

}
