/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import aQute.bnd.annotation.ProviderType;
import org.scribe.model.OAuthConfig;
import org.scribe.oauth.OAuthService;

@ProviderType
public interface ProviderConfig {
    
    /**
     * @return the configuration Id
     */
    String getConfigId();
    
    /**
     * @return the Pid of the configuration
     */
    String getPid();
    
    /**
     * @return the configured Provider Id
     */
    String getProviderId();
    
    /**
     * @return the configured OAuth client Id
     */
    String getClientId();
    
    /**
     * @return the configured OAuth client secret
     */
    String getClientSecret();
    
    /**
     * @return the configured callback url
     */
    String getCallBackUrl();
    
    /**
     * @return configured scope
     */
    String getScope();
    
    /**
     * @param callbackUrl
     * @return the {@link OAuthConfig} given the the custom callback url
     */
    OAuthConfig getOAuthConfig(final String callbackUrl);
    
    /**
     * @param provider
     * @param callbackUrl
     * @return the {@link OAuthService} given the {@link Provider} and the custom callback url
     */
    OAuthService getOAuthService(final Provider provider, final String callbackUrl);
}
