/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import aQute.bnd.annotation.ProviderType;

@ProviderType
public interface ProviderConfigManager {
    
    /**
     * Retrieve the {@link ProviderConfig} within the config with this configId
     * 
     * @param configId
     * @return the {@link ProviderConfig} or null if the configId doesn't 
     * match any registered configuration
     */
    ProviderConfig getProviderConfig(String configId);
    
    /**
     * Retrieve Iterable of {@link ProviderConfig} 
     * 
     * @return the Iterable of {@link ProviderConfig}
     */
    Iterable<ProviderConfig> getProviderConfigs();
}
