/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.configuration;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;

/**
 * Defines configuration of the saml identity provider.
 * <p>
 * This class currently contains a hard coded set of configuration information
 * specific to sitecatalyst post binding, however it should evolve to support
 * a more dynamic IDP metadata based set of configuration information.
 * </p>
 */
public class IdpConfiguration {
    /**
     * Url where saml requests should be sent.
     */
    private String idpPostUrl;

    /**
     * Url where saml logout requests should be sent.
     */
    private String idpLogoutPostUrl;

    /**
     * Alias of the idp certificate in the global trust store
     */
    private String idpCertAlias;

    /**
     * Creates a new instance of IdpConfiguration.
     */
    public IdpConfiguration() {
        super();
    }

    /**
     * Sets the alias of the IdP's certificate in the global trust store
     *
     * @param idpCertAlias String containing the alias
     */
    public void setIdpCertAlias(final String idpCertAlias) {
        this.idpCertAlias = idpCertAlias;
    }

    /**
     * @return The alias of the IdP's certificate in the global trust store
     */
    public String getIdpCertAlias() {
        return this.idpCertAlias;
    }

    /**
     * Sets the url where saml requests should be sent.
     *
     * @param idpPostUrl String containing the url where saml requests should be sent.
     */
    public void setIdpPostUrl(final String idpPostUrl) {
        this.idpPostUrl = idpPostUrl;
    }

    public void setIdpLogoutPostUrl(final String idpLogoutPostUrl) {
        this.idpLogoutPostUrl = idpLogoutPostUrl;
    }

    /**
     * Gets the url where saml requests should be sent.
     *
     * @return String containing the url where saml requests should be sent.
     */
    public String getIdpPostUrl() {
        return this.idpPostUrl;
    }

    public Certificate getCertificate(KeyStore trustStore) {
        if (trustStore != null) {
            try {
                return trustStore.getCertificate(idpCertAlias);
            } catch (KeyStoreException e) {
                throw new RuntimeException("Could not retrieve IdP certificate from TrustStore.", e);
            }
        } else {
            throw new RuntimeException("Could not access TrustStore to receive IdP certificate.");
        }
    }

    public String getIdpLogoutPostUrl() {
        return idpLogoutPostUrl;
    }

}
