/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

import java.util.Calendar;

public abstract class AbstractRequest implements Message {

	// required
	private String id;
	private String version;
	private Calendar issueInstant;
	
	// optional
	private String destination;
	private String consent;
	private Issuer issuer;
    private String rawMessage;
	private boolean signatureValid;

	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	public String getVersion() {
		return version;
	}
	
	public void setVersion(String version) {
		this.version = version;
	}
	
	public Calendar getIssueInstant() {
		return issueInstant;
	}
	
	public void setIssueInstant(Calendar issueInstant) {
		this.issueInstant = issueInstant;
	}
	
	public String getDestination() {
		return destination;
	}
	
	public void setDestination(String destination) {
		this.destination = destination;
	}
	
	public String getConsent() {
		return consent;
	}
	
	public void setConsent(String consent) {
		this.consent = consent;
	}
	
	public Issuer getIssuer() {
		return issuer;
	}
	
	public void setIssuer(Issuer issuer) {
		this.issuer = issuer;
	}
	
	public boolean hasIssuer() {
		return null != this.issuer;
	}

	public boolean hasConsent() {
		return null != this.consent && this.consent.length()>0;
	}
	
	public boolean hasDestination() {
		return null != this.destination && this.destination.length()>0;
	}

    public void setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

	public void setSignatureValid(boolean signatureValid) { this.signatureValid = signatureValid; }
	public boolean isSignatureValid() { return this.signatureValid; }
}
