/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unchecked")
public class Attribute {

    private String name;
    private String nameFormat;
    private Object attributeValue;

    /**
     * Creates a new instance of Attribute.
     */
    public Attribute() {
        super();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameFormat() {
        return nameFormat;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public void addAttributeValue(Object value) {
        if (null == this.attributeValue) {
            this.attributeValue = value;
        } else if (this.attributeValue instanceof List) {
            ((List) this.attributeValue).add(value);
        } else {
            Object oldValue = this.attributeValue;
            List<Object> newValue = new ArrayList<Object>();
            newValue.add(oldValue);
            newValue.add(value);
            this.attributeValue = newValue;
        }
    }

    public Object getValue() {
        return this.attributeValue;
    }

    public List<Object> getListValue() {
        List<Object> result;
        if (this.attributeValue instanceof List) {
            result = (List) this.attributeValue;
        } else {
            result = new ArrayList<Object>();
            result.add(this.attributeValue);
        }
        return result;
    }

}
