/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

public class AuthnRequest extends AbstractRequest {

	private Subject subject;
	private NameIdPolicy nameIdPolicy;
	private boolean forceAuthn;
	private boolean isPassive;
	private String assertionConsumerServiceUrl;
	private String assertionConsumerServiceIndex;
	private String protocolBinding;
	private String attributeConsumerServiceIndex;
	private String providerName;
	
	public AuthnRequest() {
		super();
	}
	
	public Subject getSubject() {
		return subject;
	}

	public void setSubject(Subject subject) {
		this.subject = subject;
	}

	public NameIdPolicy getNameIdPolicy() {
		return nameIdPolicy;
	}

	public void setNameIdPolicy(NameIdPolicy nameIdPolicy) {
		this.nameIdPolicy = nameIdPolicy;
	}

	public boolean isForceAuthn() {
		return forceAuthn;
	}

	public void setForceAuthn(boolean forceAuthn) {
		this.forceAuthn = forceAuthn;
	}

	public boolean isPassive() {
		return isPassive;
	}

	public void setPassive(boolean isPassive) {
		this.isPassive = isPassive;
	}

	public String getAssertionConsumerServiceUrl() {
		return assertionConsumerServiceUrl;
	}

	public void setAssertionConsumerServiceUrl(String assertionConsumerUrl) {
		this.assertionConsumerServiceUrl = assertionConsumerUrl;
	}

	public String getAssertionConsumerServiceIndex() {
		return assertionConsumerServiceIndex;
	}

	public void setAssertionConsumerServiceIndex(
			String assertionConsumerServiceIndex) {
		this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
	}

	public String getProtocolBinding() {
		return protocolBinding;
	}

	public void setProtocolBinding(String protocolBinding) {
		this.protocolBinding = protocolBinding;
	}

	public String getAttributeConsumerServiceIndex() {
		return attributeConsumerServiceIndex;
	}

	public void setAttributeConsumerServiceIndex(
			String attributeConsumerServiceIndex) {
		this.attributeConsumerServiceIndex = attributeConsumerServiceIndex;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public boolean hasProtocolBinding() {
		return (null != protocolBinding && protocolBinding.length() > 0);
	}
	
	public boolean hasNameIdPolicy() {
		return null != this.nameIdPolicy;
	}

	public boolean hasAssertionConsumerServiceURL() {
		return null != this.assertionConsumerServiceUrl && this.assertionConsumerServiceUrl.length() > 0;
	}

	public boolean hasAssertionConsumerServiceIndex() {
		return null != this.assertionConsumerServiceIndex && this.assertionConsumerServiceIndex.length() > 0;
	}
	
	// TODO JH RequestNConditions
	// TODO JH conditions
	// TODO JH scoping
	
}
