/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

import java.util.Calendar;
import java.util.LinkedList;

public class AuthnStatement {
    protected Calendar authnInstant;
    protected Calendar sessionNotOnOrAfter;
    protected String sessionIndex;
    protected LinkedList<SubjectLocality> subjectLocalities;
    protected LinkedList<AuthnContext> authnContexts;

    // Getters
    public Calendar getAuthnInstant() {
        return this.authnInstant;
    }

    public Calendar getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    // Setters
    public void setAuthnInstant(Calendar authnInstant) {
        this.authnInstant = authnInstant;
    }

    public void setSessionNotOnOrAfter(Calendar sessionNotOnOrAfter) {
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public void addSubjectLocality(SubjectLocality subjectLocality) {
        if (subjectLocalities == null) {
            subjectLocalities = new LinkedList<SubjectLocality>();
        }
        subjectLocalities.add(subjectLocality);
    }

    public void addAuthnContext(AuthnContext authnContext) {
        if (authnContexts == null) {
            authnContexts = new LinkedList<AuthnContext>();
        }
        authnContexts.add(authnContext);
    }
}
