/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

import java.util.Calendar;
import java.util.LinkedList;

public class LogoutRequest extends AbstractRequest {

    // required

    // optional
    private Calendar notOnOrAfter;
    private String reason;

    //private Object sessionIndex;
    private LinkedList<String> sessionIndices;

    // TODO JH these should extend a common base class??
    private Object baseId;
    private Object nameId;
    private Object encryptedId;
    private String nameIdFormat;

    private String nameQualifier;
    private String spNameQualifier;

    public Calendar getNotOnOrAfter() {
        return notOnOrAfter;
    }

    public void setNotOnOrAfter(Calendar notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public LinkedList<String> getSessionIndices() {
        return sessionIndices;
    }

    public void addSessionIndex(String sessionIndex) {
        if (sessionIndices == null) {
            sessionIndices = new LinkedList<String>();
        }
        sessionIndices.add(sessionIndex);
    }

    public Object getBaseId() {
        return baseId;
    }

    public void setBaseId(Object baseId) {
        this.baseId = baseId;
    }

    public Object getNameId() {
        return nameId;
    }

    public void setNameId(Object nameId) {
        this.nameId = nameId;
    }

    public Object getEncryptedId() {
        return encryptedId;
    }

    public void setEncryptedId(Object encryptedId) {
        this.encryptedId = encryptedId;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public String getNameIdFormat() {
        return nameIdFormat;
    }

    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = nameQualifier;
    }

    public String getNameQualifier() {
        return nameQualifier;
    }

    public void setSpNameQualifier(String spNameQualifier) {
        this.spNameQualifier = spNameQualifier;
    }

    public String getSpNameQualifier() {
        return spNameQualifier;
    }

}
