/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

/**
 * The saml interface identifies all top level saml requests and responses.
 * 
 * @author jasonhightower
 */
public interface Message {

	/**
	 * Gets the identifier for this message.
	 * @return String containing the identifier for this message.
	 */
	String getId();
	
	/**
	 * Sets the identifier for this message.
	 * @param id String containing the identifier for this message.
	 */
	void setId(final String id);

    /**
     * Store the message body
     * @param rawMessage The decoded, decrypted message as a String
     */
    void setRawMessage(final String rawMessage);

    /**
     * Get the message body
     * @return The decoded, decrypted message as a String
     */
    String getRawMessage();
}
