/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Response extends StatusResponse {
	
	private List<Assertion> assertions;
    private String nameId;
    private String nameIdFormat;

    private String nameQualifier;
    private String spNameQualifier;
	
	public Response() {
		super();
	}
	
	public boolean hasAssertions() {
		return null != this.assertions && 0 < this.assertions.size();
	}
	
	public void addAssertion(final Assertion assertion) {
		if (null == this.assertions) {
			this.assertions = new ArrayList<Assertion>();
		}
		this.assertions.add(assertion);
	}
	
	public List<Assertion> getAssertions() {
		if (null == this.assertions) {
			return Collections.<Assertion>emptyList();
		} else {
			return this.assertions;
		}
	}

    public void setNameId(String nameId) {
        this.nameId = nameId;
    }
    
    public String getNameId() {
        return nameId;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public String getNameIdFormat() {
        return nameIdFormat;
    }

    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = nameQualifier;
    }

    public String getNameQualifier() {
        return nameQualifier;
    }

    public void setSpNameQualifier(String spNameQualifier) {
        this.spNameQualifier = spNameQualifier;
    }

    public String getSpNameQualifier() {
        return spNameQualifier;
    }
	
}
