/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model;

public interface SamlConstants {

	// -- Status --
	
	String STATUS_PREFIX = "urn:oasis:names:tc:SAML:2.0:status:";
	
	String SUCCESS = STATUS_PREFIX + "Success";
	
	String REQUESTOR = STATUS_PREFIX + "Requestor";
	
	String RESPONDER = STATUS_PREFIX + "Responder";
	
	String VERSION_MISMATCH = STATUS_PREFIX + "VersionMismatch";
	
	String AUTHN_FAILED = STATUS_PREFIX + "AuthnFailed";
	
	String INVALID_ATTR_NAME_OR_VALUE = STATUS_PREFIX + "InvalidAttrNameOrValue";
	
	String INVALID_NAME_ID_POLICY = STATUS_PREFIX + "InvalidNameIDPolicy";
	
	String NO_AUTHN_CONTEXT = STATUS_PREFIX + "NoAuthnContext";
	
	String NO_AVAILABLE_IDP = STATUS_PREFIX + "NoAvailableIDP";
	
	String NO_SUPPORTED_IDP = STATUS_PREFIX + "NoSupportedIDP";
	
	String NO_PASSIVE = STATUS_PREFIX + "NoPassive";
	
	String PARTIAL_LOGOUT = STATUS_PREFIX + "PartialLogout";
	
	String PROXY_COUNT_EXCEEDED = STATUS_PREFIX + "ProxyCountExceeded";
	
	String REQUEST_DENIED = STATUS_PREFIX + "RequestDenied";
	
	String REQUEST_UNSUPPORTED = STATUS_PREFIX + "RequestUnsupported";
	
	String REQUEST_VERSION_DEPRECATED = STATUS_PREFIX + "RequestVersionDeprecated";
	
	String REQUEST_VERSION_TOO_HIGH = STATUS_PREFIX + "RequestVersionTooHigh";
	
	String REQUEST_VERSION_TOO_LOW = STATUS_PREFIX + "RequestVersionTooLow";
	
	String RESOURCE_NOT_RECOGNIZED = STATUS_PREFIX + "ResourceNotRecognized";
	
	String UNKNOWN_ATTR_PROFILE = STATUS_PREFIX + "UnknownAttrProfile";
	
	String UNKNOWN_PRINCIPAL = STATUS_PREFIX + "UnknownPrincipal";
	
	String UNSUPPORTED_BINDING = STATUS_PREFIX + "UnsupportedBinding";
	
	// -- version --
	
	String VERSION_2 = "2.0";
	
	// -- bindings --
	
	String POST_BINDING = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
	
	// TODO JH add other binding constants
	
	// -- Formats --
	
	String FORMAT_TRANSIENT = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
    String FORMAT_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    String FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";

    // TODO JH add other format constants
}
