/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.saml.model.xml;

import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/**
 * SamlXmlConstants defines constants specific to xml handling. These constants include
 * element names, attribute names, namespaces and date formating constants.
 *
 * @author jasonhightower
 */
public interface SamlXmlConstants {

    // namespaces
    static String SAML_PROTOCOL_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:protocol";
    static String SAML_ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";

    // attribute names
    static String ASSERTION_CONSUMER_SERVICE_URL_ATTR = "AssertionConsumerServiceURL";
    static String ASSERTION_CONSUMER_SERVICE_INDEX_ATTR = "AssertionConsumerServiceIndex";
    static String PROTOCOL_BINDING_ATTR = "ProtocolBinding";
    static String ALLOW_CREATE_ATTR = "AllowCreate";
    static String ID_ATTR = "ID";
    static String VERSION_ATTR = "Version";
    static String ISSUE_INSTANT_ATTR = "IssueInstant";
    static String DESTINATION_ATTR = "Destination";
    static String NAME_QUALIFIER_ATTR = "NameQualifier";
    static String SP_NAME_QUALIFIER_ATTR = "SPNameQualifier";
    static String FORMAT_ATTR = "Format";
    static String METHOD_ATTR = "Method";
    static String RECIPIENT_ATTR = "Recipient";
    static String IN_RESPONSE_TO_ATTR = "InResponseTo";
    static String NOT_BEFORE_ATTR = "NotBefore";
    static String NOT_ON_OR_AFTER_ATTR = "NotOnOrAfter";
    static String AUTHN_INSTANT_ATTR = "AuthnInstant";
    static String SESSION_NOT_ON_OR_AFTER_ATTR = "SessionNotOnOrAfter";
    static String SESSION_INDEX_ATTR = "SessionIndex";
    static String NAME_ATTR = "Name";
    static String NAME_FORMAT_ATTR = "NameFormat";
    static String VALUE_ATTR = "Value";
    static String CONSENT_ATTR = "Consent";

    // element names
    static String AUTHN_REQUEST_ELEMENT = "AuthnRequest";
    static String NAME_ID_POLICY_ELEMENT = "NameIDPolicy";
    static String RESPONSE_ELEMENT = "Response";
    static String ISSUER_ELEMENT = "Issuer";
    static String STATUS_ELEMENT = "Status";
    static String STATUS_CODE_ELEMENT = "StatusCode";
    static String STATUS_MESSAGE_ELEMENT = "StatusMessage";
    static String SUBJECT_ELEMENT = "Subject";
    static String NAME_ID_ELEMENT = "NameID";
    static String SUBJECT_CONFIRMATION_ELEMENT = "SubjectConfirmation";
    static String SUBJECT_CONFIRMATION_DATA_ELEMENT = "SubjectConfirmationData";
    static String CONDITIONS_ELEMENT = "Conditions";
    static String AUDIENCE_RESTRICTION_ELEMENT = "AudienceRestriction";
    static String AUDIENCE_ELEMENT = "Audience";
    static String AUTHN_STATEMENT_ELEMENT = "AuthnStatement";
    static String AUTHN_CONTEXT_ELEMENT = "AuthnContext";
    static String AUTHN_CONTEXT_CLASS_REF_ELEMENT = "AuthnContextClassRef";
    static String ATTRIBUTE_STATEMENT_ELEMENT = "AttributeStatement";
    static String ATTRIBUTE_ELEMENT = "Attribute";
    static String ATTRIBUTE_VALUE_ELEMENT = "AttributeValue";
    static String ASSERTION_ELEMENT = "Assertion";
    static String ENCRYPTED_ASSERTION_ELEMENT = "EncryptedAssertion";
    static String LOGOUT_REQUEST = "LogoutRequest";
    static String LOGOUT_RESPONSE_ELEMENT = "LogoutResponse";
    static String SESSION_INDEX_ELEMENT = "SessionIndex";

    /**
     * DateTimeFormatter used to write date information in the xsi:date format.
     */
    static DateTimeFormatter XML_DATE_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.forOffsetHours(0));
}
