/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.confmgr;

/**
 * Property names etc. for {@link Conf}.
 */
public interface ConfConstants {

    /**
     * Standard name for the reference property used to lookup configurations.
     * For example, a string property on /content pointing to /conf/default.
     *
     * <p>
     * This can be single or multi-value string property containing absolute paths.
     * In case of a multi-value, the order is important, with the first entries
     * being the lower level configurations.
     */
    String PN_CONF = "cq:conf";

    /**
     * Special node name that separates the configuration tree from the inner item tree of
     * one specific configuration, for example /conf/tenants/nike/settings/dam/imageserver.
     * This is used to remove possible ambiguities between the 2 nested trees. It means
     * that a configuration as referenced from /content cannot use this as name.
     *
     * <p>
     * Conceptually similar to "jcr:content", this acts on a higher level in the hierarchy,
     * and has its own name, since individual items within already use the document concept
     * and jcr:content.
     */
    String NN_SETTINGS = "settings";

    /**
     * Name of a boolean property to enable merging of list items. To be set on the list parent
     * or it's "jcr:content" child node if it has one.
     */
    String PN_MERGE_LIST = "mergeList";

    /**
     * Property name to use in ValueMaps returned by {@link Conf} to retrieve the name
     * of the node the map is based on. Will be the node name of the actual config item or list
     * item, not the jcr:content child node that ValueMaps will usually be based on.
     */
    String NAME = "jcr:name";

    // -----------------------------------------------< symlinks >---------------------

    /**
     * Name for the symbolic link property that allows to redirect from a configuration
     * item to a different location in the repository via an absolute path. This is the
     * same property as used for the Sling redirect servlet.
     *
     * <p>
     * This can be used to migrate parts of existing application code the Conf API while
     * still pointing to configurations e.g. under /etc that are read or written to by
     * other code that is not updated yet.
     */
    String PN_SYMLINK          = "sling:target";

    /** Begin of a variable inside a symlink string property */
    String VAR_START           = "${";

    /** End of a variable inside a symlink string property */
    String VAR_END             = "}";

    /** Symlink variable name evaluating to the target node name. */
    String VAR_RESOURCE_NAME   = "sling:targetName";

    /**
     * Symlink variable name prefix evaluating to a property on the target node.
     * For example "sling:targetProp/some/property" would represent the property
     * at the relative path "some/property" on the target node, or on it's "jcr:content"
     * child if it has one.
     */
    String VAR_PROPERTY_PREFIX = "sling:targetProp/";

}
