/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.granite.contexthub.api;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.granite.contexthub.impl.ClientLib;
import com.adobe.granite.contexthub.impl.Constants;

public class Mode {
    private boolean enabled;

    private String name;

    private String resourceType;

    private ValueMap properties;

    private Resource resource;

    private String path;

    /* list of run modes in which given mode should be initialized */
    private Set<String> runModes;

    /**
     * Constructs a module with properties from the given resource.
     *
     * @param resource resource
     */
    public Mode(Resource resource) {
        this.resource = resource;
        path = resource.getPath();
        properties = ResourceUtil.getValueMap(resource);
        String[] runModesProperty = properties.get(Constants.MODE_RUN_MODES, String[].class);

        enabled = properties.get(Constants.MODE_ENABLED, true);
        name = properties.get(Constants.MODE_TYPE, String.class);
        resourceType = resource.getResourceType();
        runModes = new TreeSet<String>();

        if (runModesProperty != null) {
            runModes.addAll(Arrays.asList(runModesProperty));
        }
    }

    /**
     * Returns list of run modes in which mode should be available.
     *
     * @return list of run modes
     */
    public Set<String> getRunModes() {
        return runModes;
    }

    /**
     * Whether this module should be enabled or not.
     *
     * @return {@code true} if this module should be enabled
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Get the name of this module.
     *
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * Get the resourceType of this module.
     *
     * @return resourceType
     */
    public String getResourceType() {
        return resourceType;
    }

    /**
     * Get all properties of this module.
     *
     * @return properties
     */
    public ValueMap getProperties() {
        return properties;
    }

    /**
     * Get the resource which describes this module.
     *
     * @return resource
     */
    public Resource getResource() {
        return resource;
    }

    /**
     * Get the path where this module is defined.
     *
     * @return path
     */
    public String getPath() {
        return path;
    }

    /**
     * Get the clientlib categories that should be included for this module.
     *
     * @return clientlib categories
     */
    public List<String> getCategories() {
        List<String> clientLibs = new ArrayList<String>();

        if (StringUtils.isNotEmpty(getName())) {
            clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODE, getName()));
            clientLibs.add(ClientLib.buildClientlibName(Constants.CONTEXTHUB_CLIENTLIB_MODE, getName(), Constants.CONTEXTHUB_CLIENTLIB_OVERRIDE_POSTFIX));
        }

        return clientLibs;
    }
}
