/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.granite.contexthub.commons;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class Utils {
    /**
     * Returns the content property of the given page. If the resource does not
     * contain this property, the parent resource is checked against given property
     * or <code>null</code> if resource has no parent.
     *
     * @param resource - resource
     * @param property - property name
     * @return the property value or <code>null</code>
     */
    public static String getInheritedProperty(Resource resource, String property) {
        String previousPath = null;
        String value = null;

        while ((value == null) && (resource != null)) {
            Resource here = resource;

            /* get "jcr:content" child if needed */
            if (!"jcr:content".equals(here.getName())) {
                here = here.getChild("jcr:content");
            }

            /* is resource found? */
            if (here != null) {
                String currentPath = here.getPath();

                if (!currentPath.equals(previousPath)) {
                    ValueMap properties = ResourceUtil.getValueMap(here);

                    previousPath = currentPath;
                    value = properties.get(property, String.class);

                    /* check parent if value is empty */
                    if ((value != null) && (value.length() == 0)) {
                        value = null;
                    }
                }
            }

            /* get parent */
            resource = resource.getParent();
        }

        return value;
    }
}
