/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.httpcache.api;

import java.io.IOException;

/**
 * Creates, manages and deletes cache files.
 */
public interface CacheStore {

    /**
     * Create a new cache file.
     *
     * @param key cache key
     * @param headers response headers
     * @return new cache file
     *
     * @throws IOException if an I/O error occurs
     */
    public CacheFile create(String key, Headers headers) throws IOException;

    /**
     * Lookup an existing cache file.
     *
     * @param key cache key
     *
     * @return existing cache file or <code>null</code>
     */
    public CacheFile lookup(String key);

    /**
     * Evict some cache file.
     *
     * @param key cache key
     *
     * @return <code>true</code> if some file was evicted;
     *         <code>false</code> otherwise
     */
    public boolean evict(String key);

    /**
     * Evict all cache files starting with a given path.
     *
     * @param host hostname
     * @param path path prefix
     */
    public void evictAll(String host, String path);
}
