/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.license;

import org.apache.sling.api.resource.ValueMap;
import org.osgi.framework.Version;

import aQute.bnd.annotation.ProviderType;

/**
 * Encapsulates information of a product or project.
 */
@ProviderType
public interface ProductInfo {

    /**
     * Returns the product name
     *
     * @return the product name.
     */
    String getName();

    /**
     * Returns the product version. e.g. "5.3.0.20091225"
     *
     * @return the product version.
     */
    Version getVersion();

    /**
     * Returns the short product name, e.g. "CQ"
     *
     * @return the short product name
     */
    String getShortName();

    /**
     * Returns the short, textual version. e.g. "5.3"
     *
     * @return the short product version.
     */
    String getShortVersion();

    /**
     * Returns the product year. e.g. "2009"
     *
     * @return the product version.
     */
    String getYear();

    /**
     * Returns the vendor. e.g. "Day Management AG"
     *
     * @return the vendor.
     */
    String getVendor();

    /**
     * Returns the vendor url. e.g. "http://www.day.com"
     *
     * @return the vendor url.
     */
    String getVendorUrl();

    /**
     * Returns the product url. e.g. "http://www.day.com/cq5"
     *
     * @return the product url.
     */
    String getUrl();

    /**
     * Returns all properties of this info.
     *
     * @return all properties.
     */
    ValueMap getProperties();
}