/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.license;

import aQute.bnd.annotation.ProviderType;


/**
 * <code>ProductInfoService</code> provides access to all {@link ProductInfo}s registered by {@link
 * ProductInfoProvider}s throughout the system.
 */
@ProviderType
public interface ProductInfoService {

    /**
     * Returns all registered {@link ProductInfo}s
     *
     * @return the product infos. At least one product info is returned.
     */
    ProductInfo[] getInfos();

    /**
     * Return the {@link License} registered for
     *
     * @return the license or <code>null</code>
     */
    License getLicense();
}