/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.maintenance;


/**
 * This class defines some constants for registering maintenance tasks.
 */
public abstract class MaintenanceConstants {

    /**
     * The unique name of a maintenance task.
     * This property is required.
     */
    public static final String PROPERTY_TASK_NAME = "granite.maintenance.name";

    /**
     * The title for a maintenance task.
     * This property is required.
     */
    public static final String PROPERTY_TASK_TITLE = "granite.maintenance.title";

    /**
     * The schedule of a maintenance task.
     * This property is optional, allowed values are {@link #SCHEDULE_DAILY},
     * {@link #SCHEDULE_WEEKLY}, {@link #SCHEDULE_MONTHLY}
     */
    public static final String PROPERTY_TASK_SCHEDULE = "granite.maintenance.schedule";

    /**
     * Boolean property to define whether a task is stoppable.
     * Optional default value false.
     */
    public static final String PROPERTY_TASK_STOPPABLE = "granite.maintenance.isStoppable";

    /**
     * Boolean property to define whether a task is conservative.
     * Optional default value true.
     */
    public static final String PROPERTY_TASK_CONSERVATIVE = "granite.maintenance.isConservative";

    /**
     * Boolean property to define whether a task supports throttling.
     * Optional default value false.
     */
    public static final String PROPERTY_TASK_THROTTLING = "granite.maintenance.supportsThrottling";

    /**
     * Boolean property to define whether a task is mandatory.
     * Optional default value false.
     * @since 1.1
     */
    public static final String PROPERTY_TASK_MANDATORY = "granite.maintenance.mandatory";

    public static final String SCHEDULE_DAILY = "daily";
    public static final String SCHEDULE_WEEKLY = "weekly";

    @Deprecated
    public static final String SCHEDULE_BIWEEKLY = "biweekly";
    public static final String SCHEDULE_MONTHLY = "monthly";

    public static final String TASK_TOPIC_PREFIX = "com/adobe/granite/maintenance/job/";

    public static final String PROPERTY_WINDOW_TITLE = "jcr:title";

    /**
     * Human readable form of the start time in 24h format, like 2:30 or 14:15.
     */
    public static final String PROPERTY_WINDOW_START_TIME = "windowStartTime";

    /**
     * Human readable form of the end time in 24h format, like 2:35 or 14:30.
     */
    public static final String PROPERTY_WINDOW_END_TIME = "windowEndTime";

    /**
     * Schedule of the window, this is either {@link #SCHEDULE_DAILY},
     * {@link #SCHEDULE_WEEKLY} or {@link #SCHEDULE_MONTHLY}
     */
    public static final String PROPERTY_WINDOW_SCHEDULE = "windowSchedule";

    /**
     * Schedule of the window, this is an array of integer values ranging from 1 = Sunday
     * to 7 = Saturday.
     */
    public static final String PROPERTY_WINDOW_SCHEDULE_WEEKDAYS = "windowScheduleWeekdays";

    /**
     * Schedule of the window, this is integer with value 0 for the first day of the month of the given type and 1 for the last one.
     * This is used for monthly scheduling, in conjunction with PROPERTY_WINDOW_SCHEDULE_WEEKDAYS, to allow period selection in
     * the form of: "The first Monday of the month / the last Friday of the month"
     */
    public static final String PROPERTY_WINDOW_SCHEDULE_FIRST_LAST_DAY = "windowFirstLastStartDay";
}
