/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.maintenance;

import java.util.Calendar;

import aQute.bnd.annotation.ProviderType;

/**
 * Description of a maintenance task
 */
@ProviderType
public interface MaintenanceTaskInfo {

    enum TaskState {
        UNKNOWN,
        SUCCEEDED,
        FAILED,
        STOPPED
    }

    enum TaskSchedule {
        DAILY,
        WEEKLY,
        @Deprecated
        BIWEEKLY,
        MONTHLY
    }

    /**
     * The unique name of a maintenance task.
     */
    String getName();

    /**
     * Whether a task supports stopping
     */
    boolean isStoppable();

    /**
     * Whether a task is conservative.
     */
    boolean isConservative();

    /**
     * Whether a task supports throttling.
     */
    boolean supportsThrottling();

    /**
     * A human readable title.
     */
    String getTitle();

    /**
     * A human readable description
     */
    String getDescription();

    /**
     * Get the last date this task has been run.
     */
    Calendar getLastRunTime();

    /**
     * Get the state of the last run.
     */
    TaskState getLastRunState();

    /**
     * Whether the task is currently running.
     */
    boolean isRunning();

    /**
     * This method always returns {@link TaskSchedule#DAILY}
     * @deprecated Use {@link #getSuggestedSchedule()}
     */
    @Deprecated
    TaskSchedule getSchedule();

    /**
     * Get the suggested schedule.
     * @return The suggested schedule or <code>null</code>
     */
    TaskSchedule getSuggestedSchedule();

    /**
     * Return the topic for the task.
     */
    String getTaskTopic();

    /**
     * Whether this task is considered to be mandatory.
     */
    boolean isMandatory();

    /**
     * @return - the task's configuration PID, to be used for configuration through the UI.
     * The method returns null if there's any problem with retrieving the PID
     */
    String getConfigurationPid();
}
