/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.maintenance;

import java.util.Collection;

import aQute.bnd.annotation.ProviderType;

/**
 * Description of a maintenance task manager.
 */
@ProviderType
public interface MaintenanceTaskManager {

    /**
     * Return all available maintenance task infos
     */
    Collection<MaintenanceTaskInfo> getMaintenanceTaskInfos();

    /**
     * Return a maintenance task info for the given name
     * @return The maintenance info or <code>null</code>
     */
    MaintenanceTaskInfo getMaintenanceTaskInfo(final String name);

    /**
     * Start the maintenance task if it exists.
     */
    void startMaintenanceTask(final String name);

    /**
     * Try to stop the maintenance task if it exists.
     */
    void stopMaintenanceTask(final String name);
}
