/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.oauth.jwt;

import java.security.Key;

/**
 * The <code>JwsValidator</code> provides a simple API to validate JWS formatted token
 * as defined in http://tools.ietf.org/html/draft-ietf-oauth-json-web-token-16
 * and http://tools.ietf.org/html/draft-ietf-jose-json-web-signature-21
 */
public interface JwsValidator {

    /**
     * Validates the given JWS token using the given key
     * 
     * @param jws The JWS token to validate
     * @param key The key used to verify the JWS.
     * This must be @link javax.crypto.spec.SecretKeySpec in case of symmetric algorithm and 
     * @link java.security.PublicKey in case of asymmetric algorithm
     * @return true if the JWS is valid as defined in http://tools.ietf.org/html/draft-ietf-jose-json-web-signature-21
     */
    public boolean validate(String jws, Key verifyingKey);
    
    
    /**
     * Validates the given JWS token using  a system key compatible with the 
     * algorithm specified in the JWS (if available)
     * 
     * @param jws The JWS token to validate
     * 
     * @return true if the JWS is valid as defined in http://tools.ietf.org/html/draft-ietf-jose-json-web-signature-21
     */
    public boolean validate(String jws);
}
