/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.granite.offloading.api;

import org.apache.sling.discovery.InstanceDescription;

import java.util.Set;

/**
 * The {@code InstanceNetworkInfoService} provides networking information about a specific instance.
 *
 * Clients outside offloading must not use this interface.
 */
public interface InstanceNetworkInfoService {

    /**
     * Retrieves the IP addresses on which an instance listens for incoming connections.
     *
     * @param instance the instance
     * @return a set of non-loopback IP addresses
     */
    Set<String> getListeningAddresses(InstanceDescription instance);

    /**
     * Retrieves the port on which an instances listens for incoming connections.
     *
     * @param instance the instance
     * @return the listening port
     */
    int getListeningPort(InstanceDescription instance);
}
