/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.granite.offloading.api;

/**
 * Defines the allowed values for a topic configuration action.
 *
 * Clients outside offloading must not use this enum.
 */
public enum TopicConfigurationAction {

    EXCLUSIVE("exclusive"), ENABLE("enable"), DISABLE("disable");

    private String action;

    private TopicConfigurationAction(String action) {
        this.action = action;
    }

    /**
     * Returns the String representation of the constant.
     * @return a string
     */
    public String getString() {
        return action;
    }

    public static TopicConfigurationAction getAction(String value) {
        for (TopicConfigurationAction action : values()) {
            if (action.getString().equals(value)) {
                return action;
            }
        }
        return null;
    }
}
