/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.granite.offloading.api;

import org.apache.sling.discovery.InstanceDescription;

import java.util.Set;

/**
 * The {@code TopicInstancesHolder} stores information about the enablement of instances for a certain processing topic.
 *
 * Clients outside offloading must not use this interface.
 */
public interface TopicInstancesHolder {

    /**
     * Provides a list of the instances enabled for processing the topic of this topic holder.
     *
     * @return a list of instance descriptions
     */
    Set<InstanceDescription> getEnabledInstances();

    /**
     * Provides a list of the instances disabled for processing the topic of this topic holder.
     *
     * @return a list of instance descriptions
     */
    Set<InstanceDescription> getDisabledInstances();

    /**
     * Gets the topic of this topic holder.
     *
     * @return the topic string
     */
    String getTopic();
}
