/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *************************************************************************/
package com.adobe.granite.offloading.workflow.api;

/**
 * Workflow process arguments for integrating job execution in workflow steps.
 */
public enum JobOffloadingProcessArguments {

    /**
     * <p>The job topic.</p>
     * <p>Mandatory. The job topic to use when adding new job.</p>
     */
    JOB_TOPIC("jobTopic"),

    /**
     * <p>The job properties.</p>
     * <p>
     * Optional. Job properties are expected to be an array of key|value pairs. Key/value are expected to be separated
     * by the pipe '|'.
     * </p>
     */
    JOB_PROPERTIES("jobProperties"),

    /**
     * <p>The offloading input.</p>
     * <p>Optional. The offloading input is expected to be an array of paths.</p>
     */
    OFFLOADING_INPUT("offloadingInput"),

    /**
     * <p>The offloading output.</p>
     * <p>Optional. The offloading output is expected to be an array of paths.</p>
     */
    OFFLOADING_OUTPUT("offloadingOutput"),

    /**
     * <p>Flag indicating if the workflow payload is supposed to be added to the offloading input.</p>
     * <p>Optional.</p>
     */
    OFFLOADING_INPUT_WORKFLOW_PAYLOAD("offloadingInputIncludeWorkflowPayload"),

    /**
     * <p>Flag indicating if the workflow payload is supposed to be added to the offloading output.</p>
     * <p>Optional.</p>
     */
    OFFLOADING_OUTPUT_WORKFLOW_PAYLOAD("offloadingOutputIncludeWorkflowPayload");

    private String argumentName;

    /**
     * Create new argument.
     *
     * @param argumentName The argument name.
     */
    JobOffloadingProcessArguments(String argumentName) {
        this.argumentName = argumentName;
    }

    /**
     * Get the argument name.
     *
     * @return The argument name.
     */
    public String getArgumentName() {
        return this.argumentName;
    }
}
