/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *************************************************************************/
package com.adobe.granite.offloading.workflow.api;

/**
 * Workflow process arguments for integrating workflow offloading in workflow steps.
 */
public enum WorkflowOffloadingProcessArguments {

    /**
     * <p>The workflow model.</p>
     * <p>Mandatory. The workflow model to use for the offloaded workflow.</p>
     */
    WORKFLOW_MODEL("workflowModel"),

    /**
     * <p>The workflow model.</p>
     * <p>
     * Mandatory. The workflow payload to use for the offloaded workflow. Only path based payloads are supported.
     * </p>
     */
    WORKFLOW_PAYLOAD("workflowPayload"),

    /**
     * <p>Flag indicating if the workflow model is supposed to be added to the offloading input.</p>
     * <p>Optional.</p>
     */
    OFFLOADING_INPUT_WORKFLOW_MODEL("offloadingInputIncludeWorkflowModel"),

    /**
     * <p>Flag indicating if the workflow model is supposed to be added to the offloading output.</p>
     * <p>Optional.</p>
     */
    OFFLOADING_OUTPUT_WORKFLOW_MODEL("offloadingOutputIncludeWorkflowModel");

    private String argumentName;

    /**
     * Create new argument.
     *
     * @param argumentName The argument name.
     */
    WorkflowOffloadingProcessArguments(String argumentName) {
        this.argumentName = argumentName;
    }

    /**
     * Get the argument name.
     *
     * @return The argument name.
     */
    public String getArgumentName() {
        return this.argumentName;
    }

}
