/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *************************************************************************/
package com.adobe.granite.offloading.workflow.api;

/**
 * Public properties for use on the job payload for workflow offloading.
 */
public enum WorkflowOffloadingProperties {

    /**
     * Job payload property for the workflow model.
     */
    OFFLOADING_WORKFLOW_MODEL("offloading.workflow.model"),

    /**
     * Job payload property for the workflow payload.
     */
    OFFLOADING_WORKFLOW_PAYLOAD("offloading.workflow.payload");

    private String propertyName;

    /**
     * Constructor for new enum value for the given property.
     *
     * @param propertyName The property name for the new enum value.
     */
    WorkflowOffloadingProperties(String propertyName) {
        this.propertyName = propertyName;
    }

    /**
     * The property name for the given enum value.
     *
     * @return The property name.
     */
    public String getPropertyName() {
        return this.propertyName;
    }


}
