/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.omnisearch.spi.core;

import java.lang.String;
import java.util.List;
import java.util.Map;

import javax.jcr.query.Query;

import com.day.cq.i18n.I18n;

import com.adobe.granite.omnisearch.api.suggestion.PredicateSuggestion;

import com.day.cq.search.result.SearchResult;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * A service provider <code>OmniSearchHandler</code> interface i.e. search module Assets, Sites
 * would need to implement this interface.
 * OmniSearch allows different modules to register themselves, by implementing this interface.
 */
public interface OmniSearchHandler {

    /**
     * This function returns ID of <code>SuggestionHandler</code> aka Search Module
     * This ID helps identify the search module uniquely i.e. assets, sites, projects etc.
     * @return ID of <code>SuggestionHandler</code>
     */
    public String getID();

    /**
     * This function returns <code>Query</code> that provides suggestions query for module
     * @param resolver ResourceResolver instance
     * @param term text term for which suggestions are require
     * @return <code>Query</code> that returns suggestions on execution
     */
    public Query getSuggestionQuery(ResourceResolver resolver, String term);

    /**This function provide predicate suggestions for the current search term. Predicates generally have
     * known limited values i.e. File Type predicate may have Images, Documents, Videos as values.
     * So, if search term is "Ima", it should return predicate "File Type: Images"
     * @param resolver ResourceResolver instance
     * @param i18n I18n instance
     * @param term text term for which suggestions are require
     * @return <code>List</code> of Predicates
     */
    public List<PredicateSuggestion> getPredicateSuggestions(ResourceResolver resolver, I18n i18n, String term);

    /**
     * This function return the Spell Check suggestion according to the search term.
     * This enables did you mean functionality
     * @param resolver ResourceResolver instance
     * @param searchTerm text term for which suggestions are require  @return <code>List</code> of Predicates
     * @return Query
     */

    public Query getSpellCheckQuery(ResourceResolver resolver, String searchTerm);

    /**
     * Every search module will store additional configuration i.e. <code>itemCardType</code>
     * <code>itemListType</code> to specify configuration that can be used to represent
     * search module resources i.e. assets, sites, users, groups.
     *
     * This api returns such a resource that stores the config.
     *
     * Additionally, this allows ability to control the visibility of particular search module
     * to a user. If a user does not have access to this resource. OmniSearch will not include this search
     * module in its searches i.e. suggestions, search etc.
     *
     * @param resolver ResourceResolver instance
     * @return <code>Resource</code> of content Node
     */
    public Resource getModuleConfig(ResourceResolver resolver);

    /**
     * returns the search results.
     *
     * @param resolver <code>ResourceResolver</code> instance
     * @param predicateParameters search predicate parameter map. Each module is independent to do search
     *                            based on existing mechanism i.e. Oak Query enginer, QueryBuilder, some other api i.e
     *                            User Manager search.
     *                            Map of parameters this should be in format of &lt;String, String&gt; or  &lt;String, String[]&gt;
     * @param limit number of result on a page
     * @param offset offset/start of result
     * @return <code>SearchResult</code>
     */
    public SearchResult getResults(ResourceResolver resolver, Map<String, Object> predicateParameters, long limit, long offset);

}
