/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.omnisearch.spi.core;


import com.adobe.granite.omnisearch.api.core.OmniSearchException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.Iterator;
import java.util.Map;

/**
 * A service provider <code>SavedSearchHandler</code> interface i.e. search module Assets, Sites
 * would need to implement this interface.
 * OmniSearch allows different modules to register themselves for Saved Search functionality , by implementing this interface.
 */

public interface SavedSearchHandler {

    /**
     * This function returns ID of <code>SavedSearchHandler</code> aka Search Module
     * This ID helps identify the search module uniquely i.e. assets, sites, projects etc.
     * @return ID of <code>SavedSearchHandler</code>
     */

    public String getID();


    /**This function returns list of all saved search for the module i.e. sites, Asset with specified limit and offset.
     * @param resolver <code>ResourceResolver</code> instance
     * @param limit number of result on a page
     * @param offset offset/start of result
     * @return <Code>Iterator</Code> of <code>Resource</code>  of nodes of saved search for the module.
     * @throws com.adobe.granite.omnisearch.api.core.OmniSearchException instance of <code>OmniSearchException</code> which provide error from the module
     */
    public Iterator<Resource> getSavedSearches(ResourceResolver resolver, long limit, long offset) throws OmniSearchException;

    /**This function provide the detail of saved query from the saved search node of the provided path
     * @param resolver <code>ResourceResolver</code> instance
     * @param path path of the node of saved search, from which parameters of saved search <code>Query</code> required
     * @return <code>Map</code> containing parameters of the <code>Query</code>
     * @throws com.adobe.granite.omnisearch.api.core.OmniSearchException instance of <code>OmniSearchException</code> which provide error from the module
     */
    public Map<String, String> getSavedSearchParameters(ResourceResolver resolver, String path) throws OmniSearchException;

    /**This function creates a  new saved search or updates a existing saved search based on the
     * parameters provided in predicateMap parameter.
     *
     * @param resolver <code>ResourceResolver</code> instance
     * @param predicateMap <code>Map</code> of type &lt;String, String&gt; containing all the parameters that needed to be saved
     *                     in query parameters of saved search node.
     * @return <code>Resource</code> that is created or updated for saved search
     * @throws com.adobe.granite.omnisearch.api.core.OmniSearchException instance of <code>OmniSearchException</code> which provide error from the module
     */
    public Resource createOrUpdateSavedSearch(ResourceResolver resolver, Map<String, String> predicateMap) throws OmniSearchException;

    /**
     * This function delete the saved search node existing on the provided path
     * @param resolver <code>ResourceResolver</code> instance
     * @param path path of saved search node that needed to be deleted.
     * @return true if node deleted successfully , false otherwise
     * @throws com.adobe.granite.omnisearch.api.core.OmniSearchException instance of <code>OmniSearchException</code> which provide error from the module
     */
    public boolean deleteSavedSearch(ResourceResolver resolver, String path) throws OmniSearchException;

}
