/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.optout.api;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;

/**
 * The <code>OptOutService</code> provides the names of cookies/headers that represent the user's choice of "opting
 * out", i.e. not wanting to be tracked by means of cookies. The service also provides the names of white-listed cookies
 * and a convenience method to determine whether a given request is opted out.
 * <p/>
 * This service is intended to be used by applications for the purpose of identifying opted-out requests and change
 * behavior regarding the setting of cookies according to the opt-out status and / or white-list.
 */
public interface OptOutService {

    /**
     * A configured collection of names of cookies that a client can set to opt-out of tracking.
     *
     * @return An unordered {@link Collection} representing the cookie names.
     */
    Collection<String> getCookieNames();

    /**
     * A map of name/value pairs of HTTP headers that a client can set to opt-out of tracking.
     *
     * @return A {@link Map} representing the configured header name/value pairs.
     */
    Map<String, String> getHeaders();

    /**
     * A collection of names of cookies that are still allowed by configuration to be set regardless of the client
     * opting out.
     *
     * @return An unordered {@link Collection} representing the cookie names.
     */
    Collection<String> getWhitelistCookieNames();

    /**
     * Determines whether the request contains any cookies or headers that match any of the configured opt-out cookies
     * or headers. In the case of cookies, the simple existence of the cookie is enough to opt-out. In the case of
     * headers, the header-value must correspond to the configured value.
     *
     * @param request The request to check.
     *
     * @return <code>true</code> if the request contains any of the cookies/headers indicated via {@link
     *         #getCookieNames()} or {@link #getHeaders}.
     */
    boolean isOptedOut(HttpServletRequest request);
}
