/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.references;

import java.util.Set;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>ReferenceAggregator</code> is an OSGi-service providing creation of {@link Reference}s
 * for the given resource.
 * The service can be obtained from the OSGi service registry via the interface.
 *
 * @since 1.0
 */
@ProviderType
public interface ReferenceAggregator {

    /**
     * Create a {@link ReferenceList} for the given <code>resource</code>.
     *
     * @param resource The {@link Resource} for which to create a {@link ReferenceList}.
     * @return The {@link ReferenceList}.
     */
    ReferenceList createReferenceList(Resource resource);

    /**
     * Create a {@link ReferenceList} for the given <code>resource</code>.
     *
     * @param resource The {@link Resource} for which to create a {@link ReferenceList}.
     * @param types An array of {@link String}s corresponding to references types to consider.
     * @return The {@link ReferenceList}.
     */
    ReferenceList createReferenceList(Resource resource, String... types);

    /**
     * Returns a set of all known references types. The types are provided by the registered {@link ReferenceProvider}s.
     *
     * @return A {@link Set} of references types and their keys (names) - or an empty set if no providers are
     *         registered.
     */
    Set<String> getTypes();

}
