/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest;

import java.util.Iterator;
import java.util.Map;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ConsumerType;

/**
 * Interface for providers of API resources which are instantiated by
 * {@link ApiResourceProviderFactory}.
 */
@ConsumerType
public interface ApiResourceProvider {

    /**
     * Returns a resource from this resource provider or {@code null} if
     * the resource provider cannot find it. The path does not come with any
     * prefix.
     *
     * @param resourceResolver The {@link org.apache.sling.api.resource.ResourceResolver} to which the
     *            returned {@link org.apache.sling.api.resource.Resource} is attached.
     * @param path The resource path.
     * @return {@code null} If this provider does not have a resource for the
     *         path.
     */
    Resource getResource(ResourceResolver resourceResolver, String path);

    /**
     * Returns an {@code java.util.Iterator} of {@link org.apache.sling.api.resource.Resource} objects loaded from
     * the children of the given {@code Resource}. The returned
     * {@link org.apache.sling.api.resource.Resource} instances are attached to the same
     * {@link org.apache.sling.api.resource.ResourceResolver} as the given {@code parent} resource.
     * <p>
     * The returned iterator may in turn contain resources which do not actually
     * exist but are required to traverse the resource tree. Such resources
     * SHOULD be {@link org.apache.sling.api.resource.SyntheticResource} objects whose resource type MUST be
     * set to {@link org.apache.sling.api.resource.ResourceProvider#RESOURCE_TYPE_SYNTHETIC}.
     *
     * @param parent The {@link org.apache.sling.api.resource.Resource} whose children are requested.
     * @return An {@code Iterator} of {@link org.apache.sling.api.resource.Resource} objects or
     *         {@code null} if the resource provider has no children for
     *         the given resource.
     * @throws NullPointerException If {@code parent} is {@code null}.
     */
    Iterator<Resource> listChildren(Resource parent);

    /**
     * Create a new resource at the given path. The new resource is put into the
     * transient space of the bound resource provider until its {@link org.apache.sling.api.resource.ResourceResolver#commit()}
     * is called.
     *
     * @param resolver The current resource resolver.
     * @param path The resource path.
     * @param properties Optional properties
     * @return The new resource.
     * @throws PersistenceException If anything fails
     */
    Resource create(ResourceResolver resolver, String path, Map<String, Object> properties) throws PersistenceException;

    /**
     * Delete the resource at the given path. This change is kept in the
     * transient space of the bound resource provider until its {@link org.apache.sling.api.resource.ResourceResolver#commit()}
     * is called.
     *
     * @param resolver The current resource resolver.
     * @param path The resource path.
     * @throws PersistenceException If anything fails
     */
    void delete(ResourceResolver resolver, String path) throws PersistenceException;

}
