/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest;

/**
 * The RequestException will be thrown if preconditions are not met to process
 * the request or its allocated resource.
 */
@SuppressWarnings("serial")
public class RequestException extends RestException {

    private int statusCode;

    /**
     * Creates a new RequestException
     * 
     * @param statusCode HTTP status code
     * @param message Error message
     */
    public RequestException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    /**
     * Returns the HTTP status code.
     * 
     * @return HTTP status code
     */
    public int getStatusCode() {
        return statusCode;
    }

}
