/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest.converter;

import aQute.bnd.annotation.ConsumerType;

/**
 * {@code ResourceConverter} is an interface describing a Java class that can perform
 * Object-to-Object conversions between model data objects and a representation
 * {@code T} of those objects that is suitable for rendering.
 * <p>
 * Implementors should ensure that a ResourceConverter can be retrieved adapting
 * a {@link org.apache.sling.api.resource.Resource} by implementing an
 * {@link org.apache.sling.api.adapter.AdapterFactory}.
 */
@ConsumerType
public interface ResourceConverter<T> {

    /**
     * Converts a {@code resource} into an object of type {@code T} to represent
     * an entity.
     * 
     * @param context Converter context
     * @return Converted object of type T
     * @throws ResourceConverterException if an error occurs during conversion
     */
    T toEntity(ResourceConverterContext context) throws ResourceConverterException;

    /**
     * Converts a {@code resource} to an object of type {@code T} to represent a
     * sub-entity. The sub-entity might only contain a subset of information and
     * might be used to represent child elements of a collection.
     * 
     * @param context Converter context
     * @return Converted sub-object of type T
     * @throws ResourceConverterException if an error occurs during conversion
     */
    T toSubEntity(ResourceConverterContext context) throws ResourceConverterException;

}
