/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest.query;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ConsumerType;

import com.adobe.granite.rest.RestException;

/**
 * Defines a service interface which might be asked to transform an arbitrary
 * string into a valid JCR-SQL2 query.
 * <p>
 * A custom query language string might be translated from:
 * </p>
 * <code>
 * SELECT page WHERE dc:description LIKE 'foo%' ORDER BY dc:title
 * </code>
 * <p>
 * into the corresponding valid JCR-SQL2 query:
 * </p>
 * <code>
 * SELECT page.* FROM [cq:Page] AS page 
 * INNER JOIN [cq:PageContent] AS child ON ISCHILDNODE(child, page) 
 * WHERE child.[jcr:description] LIKE 'foo' AND ISDESCENDANTNODE(page, [/content]) 
 * ORDER BY child.[jcr:title]
 * </code>
 */
@ConsumerType
public interface QueryTransformer {

    /**
     * Transforms the specified {@code customquery} to a valid JCR-SQL2 query.
     * The {@code customquery} is meant to be applied as the specified
     * {@code resource} as the search path.
     *
     * @param resource Resource to search in
     * @param customquery Custom query string
     * @return A valid JCR-SQL2 query string
     * @throws RestException If an error occurs during transformation
     */
    String transform(Resource resource, String customquery) throws RestException;

}
